<?php
/**
 * ADMIN PAGE: PLAYER MANAGEMENT (High-End Mobile UI)
 * AOE Nusantara League
 */

// 1. Mapping Tim
$team_map = [];
foreach ($data['teams'] as $t) {
    $team_map[$t['id']] = $t['name'];
}

// --- 2. LOGIKA PEMROSESAN DATA (POST) ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_player'])) {
    $id = $_POST['player_id'];
    
    $new_player = [
        "id" => $id ? $id : "P" . time(),
        "nickname" => htmlspecialchars($_POST['nickname']),
        "team_id" => $_POST['team_id'],
        "role" => htmlspecialchars($_POST['role']),
        "elo" => (int)($_POST['elo'] ?? 1000)
    ];

    if ($id) {
        foreach ($data['players'] as &$p) {
            if ($p['id'] === $id) { $p = $new_player; break; }
        }
    } else {
        $data['players'][] = $new_player;
    }

    file_put_contents($file_path, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: index.php?p=player&msg=success");
    exit;
}

// --- 3. LOGIKA TAMPILAN (GET) ---
$action = $_GET['action'] ?? 'list';
$edit_player = null;

if ($action == 'edit' && isset($_GET['id'])) {
    foreach ($data['players'] as $p) {
        if ($p['id'] == $_GET['id']) { $edit_player = $p; break; }
    }
}
?>

<style>
    /* Professional Component Styles */
    .btn-pro {
        display: inline-flex; align-items: center; justify-content: center; gap: 8px;
        padding: 14px 24px; border-radius: 16px; font-size: 0.85rem; font-weight: 700;
        text-decoration: none; transition: all 0.3s ease; border: 1.5px solid transparent; cursor: pointer;
        font-family: 'Roboto', sans-serif;
    }
    .btn-pro-gold { background: var(--gold); color: black; box-shadow: 0 4px 15px rgba(212, 175, 55, 0.2); }
    .btn-pro-outline { border-color: #1a1a1a; color: #666; background: #050505; }
    .btn-pro-outline:active { border-color: var(--gold); color: white; background: #0a0a0a; }

    .btn-icon-only { width: 48px; height: 48px; padding: 0; border-radius: 16px; }

    /* Player Card Styling */
    .player-card {
        background: linear-gradient(145deg, #0d0d0d, #050505);
        border: 1px solid #1a1a1a; padding: 18px; border-radius: 22px;
        margin-bottom: 15px; display: flex; justify-content: space-between; align-items: center;
    }

    .elo-badge {
        background: rgba(212, 175, 55, 0.1); color: var(--gold);
        padding: 6px 12px; border-radius: 10px; font-weight: 800; font-size: 0.75rem;
        display: inline-flex; align-items: center; gap: 6px; border: 1px solid rgba(212, 175, 55, 0.2);
    }

    /* Professional Form Styling */
    .form-container {
        background: #0a0a0a; border: 1px solid #1a1a1a;
        padding: 30px 20px; border-radius: 30px;
    }
    .form-group { margin-bottom: 25px; }
    .form-group label { 
        display: block; font-size: 0.65rem; color: #555; font-weight: 800; 
        letter-spacing: 2px; text-transform: uppercase; margin-bottom: 10px; padding-left: 5px;
    }
    .form-group input, .form-group select {
        width: 100%; padding: 18px; background: #000; border: 1.5px solid #1a1a1a;
        color: white; border-radius: 16px; font-size: 1rem; box-sizing: border-box;
        transition: all 0.3s ease;
    }
    .form-group input:focus, .form-group select:focus {
        outline: none; border-color: var(--gold); background: #050505;
        box-shadow: 0 0 20px rgba(212, 175, 55, 0.1);
    }
    /* Custom Select Arrow */
    .form-group select {
        appearance: none;
        background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24' fill='none' stroke='%23d4af37' stroke-width='2' stroke-linecap='round' stroke-linejoin='round'%3E%3Cpolyline points='6 9 12 15 18 9'%3E%3C/polyline%3E%3C/svg%3E");
        background-repeat: no-repeat; background-position: right 15px center; background-size: 18px;
    }
</style>

<?php if ($action == 'list'): ?>
    <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:30px; padding:0 5px;">
        <h2 class="section-title" style="margin:0; border:none;">Database Atlit</h2>
        <a href="?p=player&action=add" class="btn-pro btn-pro-gold">
            <span class="material-icons-outlined">add</span> REGISTRASI
        </a>
    </div>

    <div class="player-list">
        <?php if (!empty($data['players'])): ?>
            <?php foreach ($data['players'] as $p): ?>
                <div class="player-card">
                    <div style="display:flex; align-items:center; gap:18px;">
                        <div style="background:#111; width:55px; height:55px; border-radius:18px; display:flex; align-items:center; justify-content:center; border:1px solid #1a1a1a;">
                            <span class="material-icons-outlined" style="color:var(--gold); font-size:28px;">person_outline</span>
                        </div>
                        <div>
                            <div style="color:white; font-weight:900; font-size:1.1rem; letter-spacing:0.5px;"><?php echo $p['nickname']; ?></div>
                            <div style="display:flex; align-items:center; gap:8px; margin-top:5px;">
                                <span style="font-size:0.65rem; color:#555; font-weight:bold; letter-spacing:1px; text-transform:uppercase;">
                                    <?php echo $team_map[$p['team_id']] ?? 'FREE AGENT'; ?>
                                </span>
                                <span style="width:4px; height:4px; background:#333; border-radius:50%;"></span>
                                <div class="elo-badge">
                                    <span class="material-icons-outlined" style="font-size:14px;">bolt</span>
                                    <?php echo $p['elo'] ?? 1000; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="?p=player&action=edit&id=<?php echo $p['id']; ?>" class="btn-pro btn-pro-outline btn-icon-only">
                        <span class="material-icons-outlined" style="font-size:20px;">edit_note</span>
                    </a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div style="text-align:center; padding:100px 0; color:#222;">
                <span class="material-icons-outlined" style="font-size:48px; margin-bottom:10px;">groups</span>
                <p>Belum ada player terdaftar.</p>
            </div>
        <?php endif; ?>
    </div>

<?php else: ?>
    <div style="margin-bottom:25px;">
        <a href="?p=player" class="btn-pro btn-pro-outline" style="padding: 10px 18px; border-radius: 14px;">
            <span class="material-icons-outlined" style="font-size:18px;">arrow_back</span> KEMBALI
        </a>
    </div>

    <div class="form-container">
        <h2 style="font-family:'Cinzel'; color:white; font-size:1.3rem; margin:0 0 5px;"><?php echo $edit_player ? 'Edit Profil' : 'Pendaftaran'; ?></h2>
        <p style="color:#444; font-size:0.7rem; letter-spacing:2px; margin-bottom:35px; font-weight:bold;">PLAYER ARCHIVES — ANL 2026</p>
        
        <form method="POST">
            <input type="hidden" name="player_id" value="<?php echo $edit_player['id'] ?? ''; ?>">
            
            <div class="form-group">
                <label>Identitas Nickname</label>
                <input type="text" name="nickname" value="<?php echo $edit_player['nickname'] ?? ''; ?>" required placeholder="Contoh: TheViper">
            </div>

            <div class="form-group">
                <label>Afiliasi Tim / Klan</label>
                <select name="team_id">
                    <option value="">-- STATUS: FREE AGENT --</option>
                    <?php foreach($data['teams'] as $t): ?>
                        <option value="<?php echo $t['id']; ?>" <?php echo (isset($edit_player) && $edit_player['team_id'] == $t['id']) ? 'selected' : ''; ?>>
                            <?php echo $t['name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                <div class="form-group">
                    <label>Peran (Role)</label>
                    <input type="text" name="role" value="<?php echo $edit_player['role'] ?? ''; ?>" placeholder="Pocket / Flank">
                </div>
                <div class="form-group">
                    <label>Elo Rating</label>
                    <input type="number" name="elo" value="<?php echo $edit_player['elo'] ?? 1000; ?>">
                </div>
            </div>

            <div style="margin-top: 15px;">
                <button type="submit" name="save_player" class="btn-pro btn-pro-gold" style="width:100%; padding:20px;">
                    <span class="material-icons-outlined">save</span> SIMPAN DATA PLAYER
                </button>
            </div>
        </form>
    </div>
<?php endif; ?>