<?php
/**
 * ADMIN PAGE: UI SETTINGS
 * Manage Banners & Website Assets
 */

// Pastikan folder tujuan ada
$ui_dir = "../assets/img/ui/";
if (!is_dir($ui_dir)) { mkdir($ui_dir, 0777, true); }

// Inisialisasi setting jika belum ada di data.json
if (!isset($data['ui_settings'])) {
    $data['ui_settings'] = [
        "hero_banner" => "default-hero.jpg",
        "site_logo" => "",
        "announcement" => "Selamat Datang di AOE Nusantara League Season 1!"
    ];
}

// --- LOGIKA PROSES UPLOAD ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_ui'])) {
    
    // 1. Update Teks Pengumuman
    $data['ui_settings']['announcement'] = htmlspecialchars($_POST['announcement']);

    // 2. Proses Upload Banner
    if (!empty($_FILES['hero_banner']['name'])) {
        $file = $_FILES['hero_banner'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'webp'])) {
            $filename = "hero_bg_" . time() . "." . $ext;
            if (move_uploaded_file($file['tmp_name'], $ui_dir . $filename)) {
                // Hapus file lama jika bukan default
                if ($data['ui_settings']['hero_banner'] != "default-hero.jpg") {
                    @unlink($ui_dir . $data['ui_settings']['hero_banner']);
                }
                $data['ui_settings']['hero_banner'] = $filename;
            }
        }
    }

    file_put_contents($file_path, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: index.php?p=settings&msg=updated");
    exit;
}
?>

<div style="padding: 0 5px;">
    <h2 class="section-title" style="border:none; margin-bottom:5px;">UI Settings</h2>
    <p style="color:#444; font-size:0.7rem; letter-spacing:2px; margin-bottom:25px; font-weight:bold;">KUSTOMISASI VISUAL WEBSITE</p>

    <form method="POST" enctype="multipart/form-data">
        
        <div style="background:#0a0a0a; border:1px solid #1a1a1a; padding:15px; border-radius:25px; margin-bottom:25px;">
            <label style="display:block; font-size:0.65rem; color:#555; font-weight:800; letter-spacing:2px; margin-bottom:15px; text-transform:uppercase;">Hero Banner (Background)</label>
            
            <div style="width:100%; height:150px; background: url('<?php echo "../assets/img/ui/" . $data['ui_settings']['hero_banner']; ?>'); background-size:cover; background-position:center; border-radius:15px; border:1px solid #222; margin-bottom:15px; position:relative;">
                <div style="position:absolute; bottom:10px; right:10px; background:rgba(0,0,0,0.8); padding:5px 10px; border-radius:8px; font-size:0.6rem; color:#888; border:1px solid #333;">Current Banner</div>
            </div>

            <div class="form-group" style="margin-bottom:0;">
                <input type="file" name="hero_banner" accept="image/*" style="padding:12px; font-size:0.8rem;">
                <p style="color:#333; font-size:0.6rem; margin-top:8px;">Rekomendasi ukuran: 1920x1080px (Max 2MB)</p>
            </div>
        </div>

        <div class="form-container" style="background:#0a0a0a; border:1px solid #1a1a1a; padding:25px; border-radius:25px; margin-bottom:25px;">
            <div class="form-group" style="margin-bottom:0;">
                <label>Running Text / Announcement</label>
                <input type="text" name="announcement" value="<?php echo $data['ui_settings']['announcement']; ?>" placeholder="Tulis info turnamen di sini...">
            </div>
        </div>

        <button type="submit" name="update_ui" class="btn-pro btn-pro-gold" style="width:100%; padding:20px;">
            <span class="material-icons-outlined">save_as</span> SIMPAN PERUBAHAN UI
        </button>

    </form>

    <div style="margin-top:30px; padding:20px; border-radius:20px; border:1px dashed #1a1a1a; text-align:center;">
        <span class="material-icons-outlined" style="color:#222; font-size:32px;">info</span>
        <p style="color:#333; font-size:0.7rem; line-height:1.5; margin-top:10px;">Gambar yang Anda upload akan langsung menggantikan Hero Section di halaman utama website.</p>
    </div>
</div>