<?php
/**
 * PAGE: FULL SCHEDULE
 * Menampilkan seluruh jadwal AOE Nusantara League
 */

$all_matches = $matches ?? [];
$team_lookup = [];
foreach (($data['teams'] ?? []) as $t) {
    $team_lookup[$t['id']] = [
        'name' => $t['name'],
        'logo' => !empty($t['logo']) ? "assets/img/teams/".$t['logo'] : "https://ui-avatars.com/api/?name=".urlencode($t['name'])."&background=222&color=d4af37"
    ];
}

// Kelompokkan match berdasarkan musim
$seasons = [];
foreach ($all_matches as $m) {
    $s_name = $m['season'] ?? 'Lainnya';
    $seasons[$s_name][] = $m;
}
?>

<section style="padding: 20px 15px;">
    <div style="text-align:center; margin-bottom:40px;">
        <h2 style="font-family:'Cinzel'; color:var(--gold); margin:0; font-size:1.5rem;">JADWAL LENGKAP</h2>
        <div style="width:50px; height:2px; background:var(--gold); margin:10px auto;"></div>
        <p style="font-size:0.65rem; color:#444; letter-spacing:3px; font-weight:bold;">AOE NUSANTARA LEAGUE</p>
    </div>

    <?php if (empty($seasons)): ?>
        <div style="text-align:center; padding:100px 0; color:#333;">
            <span class="material-icons-outlined" style="font-size:48px;">calendar_today</span>
            <p>Jadwal belum tersedia.</p>
        </div>
    <?php else: ?>
        <?php foreach ($seasons as $season_name => $match_list): ?>
            
            <h3 style="font-family:'Cinzel'; color:white; font-size:0.9rem; margin:30px 0 20px; border-bottom:1px solid #111; padding-bottom:10px; display:flex; align-items:center; gap:10px;">
                <span class="material-icons-outlined" style="color:var(--gold);">military_tech</span>
                <?php echo strtoupper($season_name); ?>
            </h3>

            <?php foreach ($match_list as $m): 
                $t_a = $team_lookup[$m['team_a_id']] ?? ['name' => 'TBA', 'logo' => ''];
                $t_b = $team_lookup[$m['team_b_id']] ?? ['name' => 'TBA', 'logo' => ''];
                $is_finished = ($m['status'] == 'Finished');
                $is_live = ($m['status'] == 'Live');
            ?>
                <div style="background:#0a0a0a; border:1px solid #1a1a1a; border-radius:18px; padding:15px; margin-bottom:12px; display:grid; grid-template-columns: 1fr 40px 1fr; align-items:center; position:relative;">
                    
                    <div style="text-align:center;">
                        <img src="<?php echo $t_a['logo']; ?>" style="width:40px; height:40px; border-radius:10px; border:1px solid #111; margin-bottom:8px;">
                        <div style="font-size:0.75rem; font-weight:bold; color:white;"><?php echo $t_a['name']; ?></div>
                    </div>

                    <div style="text-align:center;">
                        <?php if($is_live): ?>
                            <span style="color:#e74c3c; font-size:0.6rem; font-weight:bold; display:block; margin-bottom:5px; animation: blink 1s infinite;">LIVE</span>
                        <?php endif; ?>
                        <span style="font-family:'Cinzel'; color:var(--gold); font-weight:bold; font-size:0.8rem;">VS</span>
                    </div>

                    <div style="text-align:center;">
                        <img src="<?php echo $t_b['logo']; ?>" style="width:40px; height:40px; border-radius:10px; border:1px solid #111; margin-bottom:8px;">
                        <div style="font-size:0.75rem; font-weight:bold; color:white;"><?php echo $t_b['name']; ?></div>
                    </div>

                    <div style="grid-column: span 3; margin-top:15px; padding-top:10px; border-top:1px solid #111; text-align:center; font-size:0.6rem; color:#444; font-weight:bold; letter-spacing:0.5px;">
                        <span class="material-icons-outlined" style="font-size:12px; vertical-align:middle; margin-right:4px;">schedule</span>
                        <?php echo strtoupper($m['date']); ?> — <?php echo $m['time']; ?> WIB
                    </div>
                </div>
            <?php endforeach; ?>

        <?php endforeach; ?>
    <?php endif; ?>
</section>

<style>
@keyframes blink { 0% { opacity: 1; } 50% { opacity: 0.3; } 100% { opacity: 1; } }
</style>