<?php
// Cari data tim berdasarkan ID
$current_team = null;
foreach ($teams as $t) {
    if ($t['id'] === $team_id) {
        $current_team = $t;
        break;
    }
}

// Jika tim tidak ditemukan
if (!$current_team) {
    echo "<section class='section'><p>Tim tidak ditemukan.</p><a href='index.php'>Kembali</a></section>";
    return;
}
?>

<div class="profile">
    <header class="profile-header">
        <a href="index.php" class="btn-back">← Kembali</a>
        <h1 class="team-title"><?php echo htmlspecialchars($current_team['name']); ?></h1>
        <p class="captain">Captain: <span><?php echo htmlspecialchars($current_team['captain']); ?></span></p>
    </header>

    <section class="stats-grid">
        <div class="stat-box">
            <span class="label">Matches</span>
            <span class="val"><?php echo ($current_team['played'] > 0) ? $current_team['played'] : '-'; ?></span>
        </div>
        <div class="stat-box">
            <span class="label">Win</span>
            <span class="val text-win"><?php echo ($current_team['played'] > 0) ? $current_team['win'] : '-'; ?></span>
        </div>
        <div class="stat-box">
            <span class="label">Lose</span>
            <span class="val text-lose"><?php echo ($current_team['played'] > 0) ? $current_team['lose'] : '-'; ?></span>
        </div>
    </section>

    <section class="team-matches">
        <h2 class="section-title">Riwayat Pertandingan</h2>
        <?php 
        $found_match = false;
        foreach ($matches as $m): 
            if ($m['team_a'] === $current_team['name'] || $m['team_b'] === $current_team['name']):
                $found_match = true;
        ?>
            <div class="match-card">
                <div class="match-date"><?php echo $m['date']; ?></div>
                <div class="match-teams">
                    <span class="<?php echo ($m['team_a'] === $current_team['name']) ? 'highlight' : ''; ?>">
                        <?php echo $m['team_a']; ?>
                    </span>
                    <span class="vs">VS</span>
                    <span class="<?php echo ($m['team_b'] === $current_team['name']) ? 'highlight' : ''; ?>">
                        <?php echo $m['team_b']; ?>
                    </span>
                </div>
            </div>
        <?php 
            endif;
        endforeach; 

        if (!$found_match) echo "<p class='no-data'>Belum ada jadwal pertandingan.</p>";
        ?>
    </section>
</div>