<?php
/**
 * PAGE: TOURNAMENT DETAILS
 * UI: Premium Back Button & Simplified Categories
 */
?>

<section class="details-page" style="padding: 20px 15px;">
    
    <div class="back-nav-container">
        <a href="index.php" class="back-btn-premium">
            <span class="material-icons-outlined">chevron_left</span>
            <label>KEMBALI</label>
        </a>
    </div>

    <div class="page-header-premium">
        <h2 class="cinzel-font">LIGA INFO</h2>
        <div class="gold-divider"></div>
        <p class="subtitle">AOE NUSANTARA LEAGUE — 2026</p>
    </div>

    <div class="rules-accordion">

        <div class="acc-item">
            <div class="acc-header" onclick="toggleAccordion(this)">
                <div class="acc-title">
                    <div class="icon-box"><span class="material-icons-outlined">info</span></div>
                    <span>GENERALS</span>
                </div>
                <span class="material-icons-outlined arrow">expand_more</span>
            </div>
            <div class="acc-content">
                <div style="display: grid; grid-template-columns: 1fr; gap: 10px; margin-top: 5px;">
                    
                    <div class="gen-row">
                        <div class="gen-text">
                            <strong>Liga Nusantara</strong>
                            <p>Wadah kompetisi klan AoE II tertinggi untuk menyatukan komunitas terbaik di Indonesia.</p>
                        </div>
                    </div>

                    <div class="gen-row">
                        <div class="gen-text">
                            <strong>Sistem Round Robin</strong>
                            <p>Setiap klan dipastikan akan bertemu satu sama lain dalam liga poin yang kompetitif.</p>
                        </div>
                    </div>

                    <div class="gen-row">
                        <div class="gen-text">
                            <strong>Hak Map Kandang</strong>
                            <p>Tim tuan rumah berhak menggunakan Map Kandang yang telah ditentukan saat pendaftaran.</p>
                        </div>
                    </div>

                    <div class="gen-row">
                        <div class="gen-text">
                            <strong>Sistem Pick Civ</strong>
                            <p>Pemilihan peradaban bersifat <i>Hidden</i> untuk menjaga kejutan strategi di setiap game.</p>
                        </div>
                    </div>

                </div>
            </div>
        </div>

       <div class="acc-item">
            <div class="acc-header" onclick="toggleAccordion(this)">
                <div class="acc-title">
                    <div class="icon-box"><span class="material-icons-outlined">grid_view</span></div>
                    <span>FORMAT PERTANDINGAN</span>
                </div>
                <span class="material-icons-outlined arrow">expand_more</span>
            </div>
            <div class="acc-content">
                <div class="highlight-banner" style="margin-bottom: 20px;">
                    <small>CONSTRAINTS RATING</small>
                    <h3 style="letter-spacing: 2px;">TOTAL MAX 300</h3>
                    <p style="font-size: 0.65rem; margin-top: 5px; opacity: 0.8;">Batas maksimal total rating 4 pemain dalam satu pertandingan.</p>
                </div>

                <div class="inner-card">
                    <ul class="rule-list">
                        <li>4v4 <i>Age of Empires II: Definitive Edition</i>.</li>
                        <li>Sistem Round-Robin.</li>
                        <li>Total 30 pertandingan (30 games).</li>
                        <li>Masing-masing dari 6 tim akan melawan 5 tim lainnya (undian).</li>
                        <li><i>Play All 2 Games</i> tiap pertandingan, sudah termasuk "Kandang & Tandang".</li>
                        <li>Setiap memenangkan 1 game mendapatkan 1 poin, dan 0 poin jika kalah.</li>
                        <li>Perolehan poin sementara akan diupdate setiap minggu.</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="acc-item">
            <div class="acc-header" onclick="toggleAccordion(this)">
                <div class="acc-title">
                    <div class="icon-box"><span class="material-icons-outlined">gavel</span></div>
                    <span>RULES</span>
                </div>
                <span class="material-icons-outlined arrow">expand_more</span>
            </div>
            <div class="acc-content">
                <div class="inner-card">
                    
                    <div class="rule-sub-section">
                        <h4 class="rule-sub-title">PROTOKOL PERTANDINGAN</h4>
                        <ul class="rule-list">
                            <li>Pertandingan dijalankan sesuai jadwal panitia atau kesepakatan bersama.</li>
                            <li>Terdiri dari 2 games (Kandang & Tandang).</li>
                            <li>Setiap tim memilih "Home Map" sebagai kandang dari Map Pool yang tersedia.</li>
                            <li>Penentuan Home Map pertama melalui generator panitia atau tim rating terkecil.</li>
                            <li>Seeding dilakukan berdasarkan rating pemain.</li>
                        </ul>
                    </div>

                    <div class="rule-sub-section" style="margin-top:20px;">
                        <h4 class="rule-sub-title">RATING & HANDICAP</h4>
                        <div class="highlight-banner" style="margin-bottom:15px; background:#1a1a1a; border:1px solid #333;">
                            <small>RATING CAP</small>
                            <h3>MAX 300</h3>
                        </div>
                        <ul class="rule-list">
                            <li>Beda rating > 10: Pemain rating terkecil tim bawah mendapat handicap 105%.</li>
                            <li>Beda rating > 20: 2 pemain rating terkecil mendapat handicap 105% (berlaku kelipatan hingga 40).</li>
                            <li>Perhitungan handicap dilakukan di lobby dengan konfirmasi panitia.</li>
                        </ul>
                    </div>

                    <div class="rule-sub-section" style="margin-top:20px;">
                        <h4 class="rule-sub-title">TEKNIKAL GAME</h4>
                        <ul class="rule-list">
                            <li><b>Pause:</b> Maksimal 3x per tim.</li>
                            <li><b>Restart (< 5 Menit):</b> Berlaku untuk map bugs, delay bugs, atau screen bugs.</li>
                            <li><b>Black Forest Restart:</b> Diizinkan jika imbalans sumber daya (kolam/hewan liar) sangat fatal.</li>
                            <li><b>Restart (< 10 Menit):</b> Wajib jika pemain terbukti disconnected atau out of sync.</li>
                        </ul>
                    </div>

                    <div class="rule-sub-section" style="margin-top:20px;">
                        <h4 class="rule-sub-title">RESTORE POLICY</h4>
                        <ul class="rule-list">
                            <li>Fase 0-10 menit: Tidak ada restore, wajib restart.</li>
                            <li>Fase 10-20 menit: Pilihan restart/restore (ditentukan tim poin tertinggi).</li>
                            <li>Fase > 20 menit: Wajib restore dengan bukti screenshot notifikasi.</li>
                        </ul>
                    </div>

                    <div class="rule-sub-section" style="margin-top:20px;">
                        <h4 class="rule-sub-title">LAMING & SLINGING</h4>
                        <ul class="rule-list">
                            <li><b>Laming (Fixed Map):</b> Dilarang curi babi/hewan ke TC; hanya boleh dibunuh.</li>
                            <li><b>Laming (Nomad):</b> Boleh curi; dilarang bunuh > 1 pack rusa di base musuh.</li>
                            <li><b>Slinging:</b> Dilarang kirim sumber daya ke pemain yang berada di zaman (Age) di atasnya.</li>
                            <li><b>Full Sling:</b> Dilarang saat Feudal atau Castle Age.</li>
                        </ul>
                    </div>

                    <div style="margin-top:25px; padding:15px; border-radius:15px; background:rgba(231, 76, 60, 0.1); border:1px solid #e74c3c;">
                        <p style="margin:0; font-size:0.75rem; color:#e74c3c; line-height:1.5;">
                            <b>ADMIN LOSE:</b> Pelanggaran rules berakibat kekalahan administrasi di game terkait. Keputusan panitia mutlak dan tidak dapat diganggu gugat.
                        </p>
                    </div>

                </div>
            </div>
        </div>

        <div class="acc-item">
            <div class="acc-header" onclick="toggleAccordion(this)">
                <div class="acc-title">
                    <div class="icon-box"><span class="material-icons-outlined">settings</span></div>
                    <span>LOBBY SETTINGS</span>
                </div>
                <span class="material-icons-outlined arrow">expand_more</span>
            </div>
            <div class="acc-content">
                <div class="technical-grid" style="margin-bottom:15px;">
                    <div class="t-box"><b>1.7</b><br>SPEED</div>
                    <div class="t-box"><b>HIDDEN</b><br>CIVS</div>
                </div>
                <div class="inner-card">
                    <small style="color:var(--gold); display:block; margin-bottom:8px;">MAP POOL SEASON 1</small>
                    <div class="map-gallery">
                        <span class="m-tag">Arabia</span> <span class="m-tag">Arena</span> <span class="m-tag">Nomad</span> <span class="m-tag">Lombardia</span>
                    </div>
                </div>
            </div>
        </div>

        <a href="index.php?page=prizepools" style="text-decoration:none;">
            <div class="acc-item prize-cta">
                <div class="acc-header" style="background: linear-gradient(90deg, #111, var(--gold));">
                    <div class="acc-title" style="color:#000;">
                        <div class="icon-box" style="background:#000; color:var(--gold); border:none;"><span class="material-icons-outlined">emoji_events</span></div>
                        <span style="font-weight:900;">PRIZE POOLS</span>
                    </div>
                    <span class="material-icons-outlined" style="color:#000;">arrow_forward</span>
                </div>
            </div>
        </a>

    </div>
</section>

<style>
    /* --- NEW PREMIUM BACK BUTTON --- */
    .back-nav-container {
        margin-bottom: 25px;
        display: flex;
    }
    .back-btn-premium {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none;
        background: rgba(255, 255, 255, 0.03);
        border: 1px solid #1a1a1a;
        padding: 8px 15px 8px 10px;
        border-radius: 12px;
        transition: 0.3s;
    }
    .back-btn-premium span {
        color: var(--gold);
        font-size: 20px;
    }
    .back-btn-premium label {
        color: #666;
        font-size: 0.65rem;
        font-weight: 900;
        letter-spacing: 1.5px;
        cursor: pointer;
    }
    .back-btn-premium:active {
        background: rgba(212, 175, 55, 0.1);
        transform: scale(0.95);
        border-color: var(--gold);
    }
    .back-btn-premium:active label { color: #eee; }

    /* --- Style Dasar --- */
    .page-header-premium { text-align: center; margin-bottom: 40px; }
    .cinzel-font { font-family: 'Cinzel', serif; color: var(--gold); margin: 0; font-size: 1.6rem; font-weight: 900; }
    .gold-divider { width: 40px; height: 3px; background: var(--gold); margin: 12px auto; }
    .subtitle { font-size: 0.6rem; color: #444; letter-spacing: 3px; font-weight: 800; }
    
    .acc-item { background: #080808; border: 1px solid #151515; border-radius: 20px; margin-bottom: 15px; overflow: hidden; transition: 0.3s; }
    .acc-header { padding: 18px 20px; display: flex; justify-content: space-between; align-items: center; cursor: pointer; }
    .acc-title { display: flex; align-items: center; gap: 15px; font-family: 'Cinzel', serif; font-size: 0.8rem; color: #fff; font-weight: bold; }
    .icon-box { width: 38px; height: 38px; background: #111; border-radius: 10px; display: flex; align-items: center; justify-content: center; color: var(--gold); border: 1px solid #1a1a1a; }
    
    .acc-content { max-height: 0; overflow: hidden; transition: max-height 0.4s ease; padding: 0 20px; color: #888; }
    .acc-item.active { border-color: #222; background: #0c0c0c; }
    .acc-item.active .acc-content { max-height: 1000px; padding-bottom: 25px; }

    .gen-row { background: #050505; border: 1px solid #111; padding: 15px; border-radius: 15px; display: flex; align-items: flex-start; gap: 15px; }
    .gen-icon { color: var(--gold); background: rgba(212, 175, 55, 0.05); padding: 8px; border-radius: 10px; font-size: 20px; }
    .gen-text strong { display: block; color: #fff; font-size: 0.8rem; margin-bottom: 4px; font-family: 'Cinzel', serif; }
    .gen-text p { margin: 0; font-size: 0.75rem; color: #666; line-height: 1.5; }

    .rule-list { list-style: none; padding: 0; margin: 0; font-size: 0.8rem; line-height: 1.8; }
    .rule-list li { margin-bottom: 8px; display: flex; gap: 10px; }
    .rule-list li::before { content: "\e5ca"; font-family: 'Material Icons Outlined'; color: var(--gold); font-size: 14px; }
    
    .highlight-banner { background: var(--gold); color: #000; padding: 15px; border-radius: 15px; text-align: center; }
    .highlight-banner h3 { margin: 0; font-family: 'Cinzel'; font-size: 1.5rem; }
    .m-tag { background: #111; color: #444; padding: 5px 10px; border-radius: 8px; font-size: 0.6rem; font-weight: bold; border: 1px solid #1a1a1a; }
    .txt-gold { color: var(--gold); font-weight: bold; }
    .rule-sub-title {
    color: var(--gold);
    font-size: 0.7rem;
    font-weight: 900;
    letter-spacing: 1px;
    margin-bottom: 12px;
    display: flex;
    align-items: center;
    text-transform: uppercase;
}
.rule-sub-title::after {
    content: '';
    flex: 1;
    height: 1px;
    background: #111;
    margin-left: 10px;
}
</style>

<script>
function toggleAccordion(header) {
    const item = header.parentElement;
    document.querySelectorAll('.acc-item').forEach(i => {
        if(i !== item) i.classList.remove('active');
    });
    item.classList.toggle('active');
}
</script>